function Y=interpLagrange(x,y)

if (length(x)~=length(unique(x)))
    error('Svi cvorovi interpolacije bi trebalo da budu razliciti')
end

%Izracunavanje koeficijenata Lagranzevog i.p.

%vektor P predstavlja koeficijente Lagranzevog i.p.
n = length(x);
P=zeros(n,1); 

%Prolazimo kroz sve cvorove interpolacije
for i=1:n
    
    %p je polinom koji ima nule u x1,...,xi-1,xi+1,...,xn  
    p=poly(x(find([1:n]~=i)))';   
    
    %na Lagranzev i.p. se dodaje p*y(i)/p(xi) 
    P=P+p*y(i)/polyval(p,x(i));  
end

%Y sadrzi vrednosti i.p u tackama mreze X
Y=P';  
